<?php
include_once "../bd/Conexion.php";

class Venta {

	public static function exportar($estado){
		$sentencia = "SELECT *, 
		CASE
			WHEN fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY) THEN 'ACTIVA'
			WHEN  fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW() THEN 'VENCER'
			WHEN DATE(fecha_fin) <= NOW() THEN 'VENCIDA'
			END AS estado_venta,
		DATEDIFF(fecha_fin, NOW()) AS dias_restantes 
		FROM ventas WHERE 1";
		

		if($estado === 'Activas')
			$sentencia .= " AND fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY)"; 

		if($estado === 'Vencidas') 
			$sentencia .= " AND DATE(fecha_fin) <= NOW()"; 

		if($estado === 'Vencer')
			$sentencia .= " AND fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW()";
		$ventas = BaseDatos::seleccionar($sentencia);
		return $ventas;
	}

	public static function importar($base64Archivo){
		try {
	        $archivo = base64_decode($base64Archivo);

	        $importedData = [];
	        $estado = false;
	        $csvData = array_map('str_getcsv', explode("\n", $archivo));

	        for ($i = 1; $i < count($csvData)-1; $i++) {
	            try {
	                $row = $csvData[$i];

	                $cliente = $row[0];
	                $whatsapp =  $row[1];
	                $plataforma = $row[2];
	                $no_dispositivos = $row[3];
	                $precio = $row[4];
	                $usuario = $row[5];
	                $password = $row[6];
	                $fecha_inicio = $row[7];
	                $fecha_fin = $row[8];
	                $observacion = $row[9];
	               
	                $parametros = [$cliente, $whatsapp, $plataforma, $no_dispositivos, $precio, $usuario, $password, $fecha_inicio, $fecha_fin, $observacion];
	                $insertado = BaseDatos::sentenciaPreparada("INSERT INTO ventas (cliente,whatsapp,plataforma,no_dispositivos,precio,usuario,password,fecha_inicio,fecha_fin,observaciones)
					VALUES (?,?,?,?,?,?,?,?,?,?)", $parametros);

	                if($insertado){
	                    $cadenaConfirmacion = "Contenido del cliente " . $cliente . " Insertado correctamente "."\n";
	                    array_push($importedData, $cadenaConfirmacion);
	                    
	                }
	            } catch (Exception $e) {
	                // Manejar la excepción según tus necesidades
	                $mensajeError = "Error al procesar la línea " . ($i + 1) . ": " . $e->getMessage();
	                array_push($importedData, $mensajeError);
	            }
	        }

	        return ["estado" => count($importedData) > 0, "respuesta" => $importedData];
	    } catch (Exception $e) {
	        // Manejar la excepción de nivel superior, si es necesario
	        return ["estado" => false, "respuesta" => ["Error general: " . $e->getMessage()]];
	    }
	}

	public static function estados(){
		$sentencia = "SELECT 
			SUM(
				IF(fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY), 1, 0)
			) AS activas,
			SUM(
				IF(fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW(), 1, 0)
			) AS vencer,
			SUM(
				IF(DATE(fecha_fin) <= NOW(), 1, 0)
			) AS vencidas,
			SUM(precio) AS total_ventas,
			SUM(
				IF(fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY), precio, 0)
			) AS total_activas,
			SUM(
				IF(fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW(), precio, 0)
			) AS total_vencer,
			SUM(
				IF(DATE(fecha_fin) <= NOW(), precio, 0)
			) AS total_vencidas
			FROM ventas
		";
		return BaseDatos::seleccionarObjeto($sentencia);
	}

	public static function nuevaVenta($venta){
		$sentencia = "INSERT INTO ventas (cliente,whatsapp,plataforma,no_dispositivos,precio,usuario,password,fecha_inicio,fecha_fin,observaciones)
			VALUES (?,?,?,?,?,?,?,?,?,?)";
		$parametros = [
			$venta->cliente,
			$venta->whatsapp,
			$venta->plataforma,
			$venta->noDispositivos,
			$venta->precio,
			$venta->usuario,
			$venta->contrasenia,
			$venta->fechaInicio,
			$venta->fechaFin,
			$venta->observacion,
		];
		return BaseDatos::sentenciaPreparada($sentencia, $parametros);
	}

	public static function obtenerVentas($pagina, $por_pagina, $busqueda, $filtro){
		$offset =  ($pagina - 1) * $por_pagina;
		$sentencia = "SELECT *, 
		CASE
			WHEN fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY) THEN 'ACTIVA'
			WHEN  fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW() THEN 'VENCER'
			WHEN DATE(fecha_fin) <= NOW() THEN 'VENCIDA'
			END AS estado_venta,
		DATEDIFF(fecha_fin, NOW()) AS dias_restantes 
		FROM ventas WHERE 1";
		$params = [];

		if($busqueda !== ""){
			$sentencia.= " AND  (cliente LIKE ? OR whatsapp LIKE ? OR plataforma LIKE ? OR usuario LIKE ? OR observaciones LIKE ? )";
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
		}

		if($filtro === 'Activas')
			$sentencia .= " AND fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY)"; 

		if($filtro === 'Vencidas') 
			$sentencia .= " AND DATE(fecha_fin) <= NOW()"; 

		if($filtro === 'Vencer')
			$sentencia .= " AND fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW()";

		$sentencia.=" LIMIT ? OFFSET ?";
		array_push($params, $por_pagina);
		array_push($params, $offset);

		$ventas = BaseDatos::seleccionar($sentencia, $params);
		$estados = self::estados();
		$total_items = self::totalItems($busqueda, $filtro);
		return ["ventas" => $ventas, "estados" => $estados, "total_items" => $total_items];
	}

	public static function totalItems($busqueda, $filtro){
		$sentencia = "SELECT COUNT(*) AS total FROM ventas WHERE 1";
		$params = [];

		if($busqueda !== ""){
			$sentencia.= " AND  (cliente LIKE ? OR whatsapp LIKE ? OR plataforma LIKE ? OR usuario LIKE ? OR observaciones LIKE ? )";
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
			array_push($params, "%$busqueda%");
		}

		if($filtro === 'Activas')
			$sentencia .= " AND fecha_fin > NOW() AND fecha_fin > DATE_ADD(NOW(), INTERVAL 3 DAY)"; 

		if($filtro === 'Vencidas') 
			$sentencia .= " AND DATE(fecha_fin) <= NOW()"; 

		if($filtro === 'Vencer')
			$sentencia .= " AND fecha_fin <= DATE_ADD(NOW(), INTERVAL 3 DAY) AND fecha_fin > NOW()";

		$resultado = BaseDatos::seleccionarObjeto($sentencia, $params);
		if($resultado) return $resultado->total;
		return 0;
	}

	public static function eliminar($id){
		$sentencia = "DELETE FROM ventas WHERE id_venta = ?";
		return BaseDatos::sentenciaPreparada($sentencia, [$id]);	
	}

	public static function editar($venta){
		$sentencia = "UPDATE ventas SET cliente = ?, whatsapp = ?, plataforma = ?, no_dispositivos = ?, precio = ?, usuario = ?, password = ?, fecha_inicio = ?, fecha_fin = ?, observaciones = ? WHERE id_venta = ?";
		$parametros = [
			$venta->cliente,
			$venta->whatsapp,
			$venta->plataforma,
			$venta->noDispositivos,
			$venta->precio,
			$venta->usuario,
			$venta->contrasenia,
			$venta->fechaInicio,
			$venta->fechaFin,
			$venta->observacion,
			$venta->id
		];
		return BaseDatos::sentenciaPreparada($sentencia, $parametros);
	}
}
?>